# -*- coding: utf-8 -*-
import nltk
import re
import pandas as pd
from sklearn.feature_extraction.text import CountVectorizer
from sklearn.naive_bayes import MultinomialNB
from sklearn import metrics
from sklearn.model_selection import cross_val_predict

def str_tuple(t, encoding="ascii"):
	return tuple([i.encode(encoding) for i in t])


def Preprocessamento(instancia):
    #remove links, pontos, virgulas,ponto e virgulas dos tweets
    #coloca tudo em minusculo
    instancia = re.sub(r"http\S+", "", instancia).lower().replace(',','').replace('.','').replace(';','').replace('-','').replace(':','')
    return (instancia)

#Ler arquivo de dados e conta a quantidade de linhas
dataset = pd.read_csv('Tweets_Mg.csv',encoding='utf-8')

dataset.count()
dataset[dataset.Classificacao=='Neutro'].count()
dataset[dataset.Classificacao=='Positivo'].count()
dataset[dataset.Classificacao=='Negativo'].count()

#Separando tweets(Entrada x) e seus sentimentos (Classe y)
tweets = dataset['Text'].values
classes = dataset['Classificacao'].values

#TREINAMENTO 

#Pre-processamento -> Extracao de caracteristicas
vectorizer = CountVectorizer(analyzer="word")	# bag of words
freq_tweets = vectorizer.fit_transform(tweets)	# contagem de frequencia

#Gerando o modelo (Treinamento Supervisionado)
modelo = MultinomialNB()		# MultinomialNB(alpha=1.0, class_prior=None, fit_prior=True)
modelo.fit(freq_tweets,classes)

#### TESTE
#Instancias de teste dentro de uma lista
testes = ['Esse governo está no início, vamos ver o que vai dar','Estou muito feliz com o governo de Minas esse ano','O estado de Minas Gerais decretou calamidade financeira!!!','A segurança desse país está deixando a desejar','O governador de Minas é do PT']

classes_testes = ['Neutro', 'Positivo', 'Negativo', 'Negativo', 'Neutro']

freq_testes = vectorizer.transform(testes)
resultados_testes = modelo.predict(freq_testes)

print(str_tuple(resultados_testes))

# Acurácia média
print (metrics.accuracy_score(classes_testes,resultados_testes))    #0.8831564824978656

# Medidas de validação (Precision, Recall, F1-Score)
sentimento=['Positivo','Negativo','Neutro']
print (metrics.classification_report(classes_testes, resultados_testes,sentimento))

#print (metrics.f1_score(classes_testes, resultados_testes, average='weighted'))

