# -*- coding: utf-8 -*-

import nltk
import re
import pandas as pd
from sklearn.feature_extraction.text import CountVectorizer
from sklearn.naive_bayes import MultinomialNB
from sklearn import metrics
from sklearn.model_selection import cross_val_predict

#Ler arquivo de dados e conta a quantidade de linhas
dataset = pd.read_csv('Tweets_Mg.csv',encoding='utf-8')

dataset.count()
dataset[dataset.Classificacao=='Neutro'].count()
dataset[dataset.Classificacao=='Positivo'].count()
dataset[dataset.Classificacao=='Negativo'].count()

#Separando tweets e suas classes
tweets = dataset['Text'].values
classes = dataset['Classificacao'].values

### TREINAMENTO

#Extração de características
vectorizer = CountVectorizer(ngram_range=(1,2))		#Bigram
freq_tweets = vectorizer.fit_transform(tweets)


#Gerando o modelo (Treinamento Supervisionado)
modelo = MultinomialNB()		# MultinomialNB(alpha=1.0, class_prior=None, fit_prior=True)
modelo.fit(freq_tweets,classes)

##### AVALIÇÃO DO MODELO

#Cross validation k-fold (10)
resultados = cross_val_predict(modelo, freq_tweets, classes, cv=10)

# Acurácia média
metrics.accuracy_score(classes,resultados)    #0.8831564824978656

# Medidas de validação (Precision, Recall, F1-Score)
sentimento=['Positivo','Negativo','Neutro']
print (metrics.classification_report(classes,resultados,sentimento))

# Matriz de confusão
print ("Matriz de confusão")
print (pd.crosstab(classes, resultados, rownames=['Real'], colnames=['Predito'], margins=True))


